var messageShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event)
{
	if (!messageShown && !hasImage) {
		// fade in the flip widget
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer = null;
		}

		var starttime = (new Date).getTime() - 13; // set it back one frame

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('usageindicator');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		messageShown = true;
	}
	else if (hasImage) {
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer = null;
			document.getElementById ('usageindicator').style.opacity = 0.0;
		}
	}
}


function mouseexit (event)
{
	if (messageShown) {
		// fade in the flip widget
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer = null;
		}

		var starttime = (new Date).getTime() - 13; // set it back one frame

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('usageindicator');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		messageShown = false;
	}
}

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();

	T = limit_3(time-animation.starttime, 0, animation.duration);

	if (T >= animation.duration) {
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.firstElement.style.opacity = animation.now;
}
